/* eslint-disable guard-for-in */
const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('deleteTestSvc')
const {
  getServicesFormat, getAllNamespace,
} = require('../kubeService/service')
const getClient = require('../resource/getClient')
const dingTalk = require('../utils/dingTalk')
const APP_CONFIG = require('../config')

const deploy = async (cluster) => {
  logger.info('deleteTestSvc job start')
  const client = await getClient(cluster)
  const ns = await getAllNamespace(client.clientInfo)
  const summary = {}

  for (const namespace of ns.namespaces) {
    if (namespace.description) {
      logger.info('开始检查ns:', namespace.name)
      if (!summary[namespace.description]) {
        summary[namespace.description] = {}
      }
      summary[namespace.description][namespace.name] = []
      const svcs = await getServicesFormat(client.clientInfo, namespace.name)
      for (const svc of svcs) {
        if (svc.labels.type !== 'base' && !~svc.image.indexOf('latest') && !~svc.image.search(':master-') && ~svc.createdAt.search('month')) {
          summary[namespace.description][namespace.name].push(svc.image.split('/')[2])
        }
      }
      logger.info('ns:', namespace.name, '检查完毕')
    }
  }

  const title = '早。以下测试分支已经一个月没有更新啦，请确认该服务是否还在使用，如无回复将会被删除\n\n'
  for (const type in summary) {
    let text = ''
    for (const i in summary[type]) {
      if (summary[type][i].length) {
        text = `${text}${i} : \n\n${summary[type][i].join('\n\n')}\n\n`
      }
    }
    if (text) text = title + text
    dingTalk('daily 闲置服务检查', text, APP_CONFIG.deleteTestSvcRobot[type])
  }
  logger.info('deleteTestSvc job end')
}

module.exports = () => {
  // schedule.scheduleJob('*/1 * * * *', async () => {
  schedule.scheduleJob('59 9 * * 1-5', async () => {
    try {
      await deploy('qa')
    } catch (e) {
      logger.info('deleteTestSvc', e)
    }
  });
}
