const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

module.exports = function client() {
  const client = {}
  return async function (ctx, next) {
    const exclude = ['/service/listEnvVarsNew']
    if (exclude.includes(ctx.path)) {
      await next()
    } else {
      const cluster = ctx.request.headers.cluster
      let yaml = ''
      switch (cluster) {
        case 'qa':
          yaml = './../../kubeService/kubeConfig-qa.yaml'
          break
        case 'dev-ops':
          yaml = './../../kubeService/kubeConfig-dev-ops.yaml'
          break
        case 'qke':
          yaml = './../../kubeService/kubeConfig-qke.yaml'
          break
        default:
          ctx.body = {
            code: '0001',
            msg: '请选择集群的名字',
          }
          return
      }
      if (!client[cluster]) {
        client[cluster] = new Client({
          config: config.fromKubeconfig(
            path.resolve(__dirname, yaml),
          ),
          version: '1.10',
        })
        client.clusterName = cluster
      }
      ctx.client = client[cluster]
      ctx.cluster = client.clusterName
      await next()
    }
  }
}
