const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

const client = new Client({
  config: config.fromKubeconfig(
    path.resolve(__dirname, './kubeConfig.yaml'),
  ),
  version: '1.10',
})

const serviceGet = async (namespace, serviceName) => client.api.v1.namespaces(namespace).services(serviceName).get()
const podGet = async namespace => client.api.v1.namespaces(namespace).pods.get()

module.exports = {
  serviceGet,
  podGet,
}
