const Router = require('koa-router')
const bodyParser = require('koa-bodyparser');
const yaml = require('js-yaml')
const templates = require('../serviceTemplate')

const client = require('../services/tke.service').create({
  secretId: 'AKID4rY7wwNphsUcaFsy1pRtKhQvDj4CA3Ac',
  secretKey: 'YBduRnjgVRGzmagZJbss3Vo58wWCyhgc',
  clusterId: 'cls-acfx4pvj',
  region: 'ap-beijing'
})
const TYPES = ['ui', 'java', 'nodejs', 'python', 'go']

const router = new Router();

module.exports = router

router.use(async (ctx, next) => {
  ctx.k8s = client
  await next()
}, bodyParser())

router.get('/', async ctx => {
  let data = await client.service_list(ctx.query.namespace)
  ctx.body = ctx.ok(data)
})

router.post('/create', async ctx => {
  let {type, serviceName, namespace, image, system_name} = ctx.request.body
  if (!TYPES.includes(type)) {
    return ctx.body = ctx.fail('不支持的服务类型')
  }

  // try {
  //   let svc = await client.service_get(serviceName, namespace)
  //   if (svc) {
  //     return ctx.body = ctx.fail('服务已经存在')  
  //   }
  // } catch (e) {
  // }

  let data = {
    serviceName,
    namespace,
    image,
    system_name
  }
  if (!system_name) {
    // ui abTest的时候不一样
    data.system_name = serviceName
  }
  let template = templates[type].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
    if (data[arguments[1]] === undefined) {
      throw new Error('缺少模板所需变量')
    }
    return data[arguments[1]]
  })
  let params = yaml.load(template)
  await client.service_create(params)
  ctx.body = ctx.ok('创建成功')
})

router.post('/delete', async ctx => {
  await client.service_delete(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok('删除成功')
})

router.post('/modifyImage', async ctx => {
  await client.service_modifyImage(ctx.request.body.serviceName, ctx.request.body.image, ctx.request.body.namespace)
  ctx.body = ctx.ok('更新成功')
})

