const Koa = require('koa')
const Router = require('koa-router')

const error = require('../middleware/error')
const result = require('../middleware/result')

const namespaceRoute = require('./namespace')
const serviceRoute = require('./service')
const baseServiceRoute = require('./baseService')

function loadRoutes (router) {
  router
    .use(error())
    .use(result())
    .use('/namespace', namespaceRoute.routes())
    .use('/service', serviceRoute.routes())
    .use('/baseService', baseServiceRoute.routes())
}

exports.start = function () {
  // 加载各种服务

  const app = new Koa();
  const router = new Router();

  // 加载所有路由
  loadRoutes(router)

  app.use(router.routes());
  app.listen(4000);
  console.log('app start', 4000)
}