const schedule = require('node-schedule')
const _ = require('lodash')
const sleep = require('sleep')
const logger = require('koa-log4').getLogger('deployLatest')
// const cluster = require('../services/tke.clusterService').create()
const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config
const { serviceRestart, getServicesFormat, getAllNamespace } = require('../kubeService/service')
const container = require('../services/tke.containerService').create()

const repoNS = ['qa-java', 'qa-ui', 'qa-node', 'qa-python']
// const testNamespace = ['qa', 'fe', 'data', 'fis', 'xyqb2']

const client = new Client({
  config: config.fromKubeconfig(
    path.resolve(__dirname, './../kubeService/kubeConfig-qa.yaml'),
  ),
  version: '1.10',
})
const deploy = async () => {
  logger.info('deployLatest start')
  for (const ns of repoNS) {
    const repoNSData = await container.repository_get(ns)
    for (const repo of repoNSData.repoInfo) {
      logger.info('开始检查仓库项目:', repo.reponame)
      const repoName = repo.reponame.split('/')[1]
      const latest = await container.getTagByName(repo.reponame, 'latest')
      const latestImageID = _.get(latest.tagInfo, '[0].tagId', '')
      const ns = await getAllNamespace(client)
      // ns = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
      for (const namespace of ns.namespaces) {
        const svcs = await getServicesFormat(client, namespace.name)
        for (const svc of svcs) {
          if (svc.serviceName === repoName && svc.image.indexOf('latest') !== -1) {
            if (latestImageID !== svc.imageID.split('@')[1]) {
              logger.info('部署项目', namespace.name, svc.podName)
              await serviceRestart(client, namespace.name, svc.podName)
              sleep.msleep(500)
            }
          }
        }
      }
      logger.info('仓库项目检查完毕:', repo.reponame)
    }
  }
  logger.info('deployLatest end')
}

module.exports = () => {
  // schedule.scheduleJob('*/2 * * * *', async () => {
  schedule.scheduleJob('0 2 * * *', async () => {
    try {
      await deploy()
    } catch (e) {
      logger.info('deployLatest', e)
    }
  });
}
