const schedule = require('node-schedule')
const request = require('request')
const moment = require('moment')
const Redis = require('ioredis')
const logger = require('koa-log4').getLogger()
const { podGetstatus } = require('../kubeService/service')


const redis = new Redis(6380, '172.30.220.22')
const awaitRequest = function (options) {
  return new Promise((resolve, reject) => {
    request(options, (error, res, body) => {
      if (error) {
        reject(error)
      } else {
        resolve(body)
      }
    })
  })
}
const dingTalkPush = async function (item) {
  const status = Object.keys(item.status.containerStatuses[0].state)[0]
  let message = ''
  if (status === 'running') {
    message = '服务启动可能出现错误,请及时查看'
  } else {
    message = item.status.containerStatuses[0].state[status].reason
  }
  const dingData = {
    msgtype: 'markdown',
    markdown: {
      title: 'pipeline项目添加信息如下',
      text: '> 描述信息:  腾讯云服务异常提醒通知\n\n'
        + `> 项目名称 :  ${item.metadata.labels['qcloud-app']}\n\n`
        + `> 项目类型 :  ${item.metadata.labels.type}\n\n`
        + `> 命名空间 :${item.metadata.namespace}\n\n`
        + `> 异常原因 : ${message}\n\n`
        + `> 时间戳   : ${moment().format('YYYY-MM-DD HH:mm:ss')}\n\n`,
    },
  }
  const res = await awaitRequest({
    url: 'https://oapi.dingtalk.com/robot/send?access_token=8e0cdbbb980da00a2c56fdf1724692f8cb4daa0c5d6d90b02c739b4dbd05464d',
    method: 'POST',
    headers: {
      'Content-Type': 'application/json;charset=utf-8',
    },
    body: JSON.stringify(dingData),
  })
  if (JSON.parse(res).errcode === 0) {
    await redis.set(`${item.metadata.namespace}:${item.metadata.name}`, 'send')
  } else {
    logger.error(res.errmsg)
  }
}
const job = async () => {
  const listPods = await podGetstatus()
  listPods.body.items.forEach((item) => {
    item.status.conditions.forEach(async (value) => {
      if (value.status !== 'True') {
        const res = await redis.get(`${item.metadata.namespace}:${item.metadata.name}`)

        if (res != null) {
          if (res === 'send') {
            logger.info(item.metadata.name, ':已到达阈值并已发送钉钉提醒服务')
          } else {
            const counter = Number(res)
            if (counter > 5) {
              await redis.set(`${item.metadata.namespace}:${item.metadata.name}`, counter + 1)
              // const res = await podlog(item.metadata.namespace, item.metadata.name)
              dingTalkPush(item, counter)
            } else {
              await redis.set(`${item.metadata.namespace}:${item.metadata.name}`, counter + 1)
            }
          }
        } else {
          await redis.set(`${item.metadata.namespace}:${item.metadata.name}`, 1)
          // 提醒的推送通知一天重置一次,避免多次提醒
          await redis.expire(`${item.metadata.namespace}:${item.metadata.name}`, 3600 * 24)
        }
      }
    })
  })
}
module.exports = (cron) => {
  // 每分钟的第30秒定时执行一次:
  schedule.scheduleJob(cron, () => {
    job()
  });
}
