const Router = require('koa-router')
const yaml = require('js-yaml')
const logger = require('koa-log4').getLogger()

const templates = require('../serviceTemplate')
const { ingressCreate, ingressDelete } = require('../kubeService/ingress')

const router = new Router()
module.exports = router

router.get('/', async (ctx) => {
  const data = await ctx.cluster.service_list(ctx.query.namespace)
  const getDetail = async (item) => {
    const detaildata = await ctx.cluster.service_get(item.serviceName, ctx.query.namespace)
    return detaildata
  }
  const task = []
  for (let i = 0; i < data.services.length; i += 1) {
    if (data.services[i].userLabels.type === 'base') {
      task.push(getDetail(data.services[i]))
    }
  }
  const result = await Promise.all(task)
  for (let i = 0; i < data.services.length; i += 1) {
    for (let j = 0; j < result.length; j += 1) {
      if (data.services[i].serviceName === result[j].service.serviceName) {
        data.services[i].portMappings = result[j].service.portMappings
        data.services[i].image = result[j].service.containers[0].image
      }
    }
  }
  ctx.body = ctx.ok(data)
})

const createService = async (ctx) => {
  const {
    type, serviceName, namespace, image, system_name, domain, label,
  } = ctx.request.body
  logger.info('创建服务', ctx.request.body)
  const data = {
    serviceName,
    namespace,
    image,
    system_name,
  }
  if (!system_name) {
    // ui abTest的时候不一样
    data.system_name = serviceName
  }

  const template = templates[type].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
    if (data[arguments[1]] === undefined) {
      throw new Error(`缺少模板所需变量: ${arguments[1]}`)
    }
    return data[arguments[1]]
  })
  const params = yaml.load(template)
  await ctx.cluster.service_create(params, label)
  if (label !== 'base') {
    await ingressCreate(namespace, serviceName, domain)
  }
  ctx.body = ctx.ok('创建成功')
}

router.post('/create', async (ctx) => {
  await createService(ctx)
})

router.post('/details', async (ctx) => {
  const data = await ctx.cluster.service_get(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok(data)
})
router.post('/delete', async (ctx) => {
  await ingressDelete(ctx.request.body.namespace, ctx.request.body.serviceName)
  await ctx.cluster.service_delete(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok('删除成功')
})

router.post('/modifyImage', async (ctx) => {
  let list = await ctx.cluster.service_list(ctx.request.body.namespace)
  list = list.services.map(item => item.serviceName)

  if (list.includes(ctx.request.body.serviceName)) {
    await ctx.cluster.service_modifyImage(ctx.request.body.serviceName, ctx.request.body.image, ctx.request.body.namespace)
  } else {
    await createService(ctx)
  }

  ctx.body = ctx.ok('更新成功')
})
router.post('/instance', async (ctx) => {
  const data = await ctx.cluster.instance_get(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok(data)
})
router.post('/redeploy', async (ctx) => {
  await ctx.cluster.service_redeployment(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok('服务重部署成功')
})
