const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config
const _ = require('lodash')
const yaml = require('js-yaml')
const yamls = require('../yamls')

const client = new Client({
  config: config.fromKubeconfig(
    path.resolve(__dirname, './kubeConfig.yaml'),
  ),
  version: '1.10',
})

const serviceGet = async (namespace, serviceName) => client.api.v1.namespaces(namespace).services(serviceName).get()
const podGet = async namespace => client.api.v1.namespaces(namespace).pods.get()

const serviceCreate = async (namespace, serviceName, image) => {
  const data = {
    namespace,
    app: serviceName,
    image,
  }

  const pvcName = `${serviceName}-${namespace}`
  const yamlManifest = yamls[serviceName].replace(/{{([A-Za-z0-9_\.]+)}}/g, function () {
    if (_.get(data, arguments[1], null) === null) {
      throw new Error(`缺少模板所需变量: ${arguments[1]}`)
    }
    return _.get(data, arguments[1])
  })

  const yamlArray = yamlManifest.split('---')

  for (const item of yamlArray) {
    const jsonObj = yaml.load(item);
    let pvc

    switch (jsonObj.kind) {
      case 'Service':
        await client.api.v1.namespaces(namespace).services.post({ body: jsonObj })
        break;

      case 'Deployment':
        await client.apis.apps.v1beta1.namespaces(namespace).deployments.post({ body: jsonObj })
        break;

      case 'PersistentVolumeClaim':
        pvc = await client.api.v1.namespaces(namespace).persistentvolumeclaims.get()
        pvc = pvc.body.items.filter(item => item.metadata.name === pvcName)
        if (!pvc.length) {
          await client.api.v1.namespaces(namespace).persistentvolumeclaims.post({ body: jsonObj })
        }
        break;

      default:
        break;
    }
  }
}

module.exports = {
  serviceGet,
  podGet,
  serviceCreate,
}
