const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

const client = new Client({ config: config.fromKubeconfig(), version: '1.9' })
const getManifest = (namespace, servicename) => ({
  apiVersion: 'extensions/v1beta1',
  kind: 'Ingress',
  metadata: {
    name: servicename,
    namespace,
    annotations: {
      'kubernetes.io/ingress.class': 'traefik',
    },
  },
  spec: {
    rules: [
      {
        host: `${servicename}-${namespace}.liangkebang.net`,
        http: {
          paths: [
            {
              path: '/',
              backend: {
                serviceName: `${servicename}`,
                servicePort: 80,
              },
            },
          ],
        },
      },
    ],
  },
})
const ingressGet = async (namespace, servicename) => client.apis.extensions.v1beta1.namespaces(namespace)
  .ingresses(servicename).get()
const ingressCreate = async (namespace, servicename) => {
  const Manifest = getManifest(namespace, servicename)
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses
    .post({ body: Manifest })
}
const ingressUpdate = async (namespace, servicename, host) => {
  const Manifest = getManifest(namespace, servicename)
  Manifest.spec.rules[0].host = host
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses(servicename)
    .patch({ body: Manifest })
}
const ingressDelete = async (namespace, servicename) => {
  await client.apis.extensions.v1beta1.namespaces(namespace).ingresses(servicename).delete()
}
module.exports = {
  ingressGet,
  ingressCreate,
  ingressUpdate,
  ingressDelete,
}
