
const path = require('path')

const logDir = path.resolve(process.cwd(), './logs')
module.exports = {
  devlog: {
    appenders: {
      out: {type: 'stdout'},
      app: {
        type: 'dateFile', filename: `${logDir}/tke-eos.log`, daysToKeep: 3, compress: true,
      },
      error: {
        type: 'dateFile', filename: `${logDir}/tke-eos.error.log`, daysToKeep: 3, compress: true,
      },
      timing: {
        type: 'dateFile', filename: `${logDir}/tke-eos.timing.log`, daysToKeep: 3, compress: true,
      },
      just_errors: {type: 'logLevelFilter', appender: 'error', level: 'error'},
    },
    categories: {
      default: {appenders: ['out', 'app', 'just_errors'], level: 'info'},
      error: {appenders: ['out', 'error'], level: 'error'},
      timing: {appenders: ['out', 'timing'], level: 'info'}
    }
  }
}
