const request = require('request')

module.exports = function (options) {
  return new Promise((resolve, reject) => {
    request(Object.assign(options, {
      headers: {
        'Content-Type': 'application/json;charset=utf-8',
        cluster: 'qa',
      },
    }), (error, res, body) => {
      if (error) {
        reject(error)
      } else {
        resolve(JSON.parse(body))
      }
    })
  })
}
