const Client = require('./tke.service')
const domainConfig = require('../config')

class Container extends Client {
  constructor() {
    super();
    this.endpoint = domainConfig.containerPoint
  }

  repository_get(namespace) {
    return this.post('SearchUserRepository', { namespace, limit: 50 })
  }

  tag_get(reponame) {
    return this.post('GetTagList', { reponame })
  }

  getTagByName(reponame, tag) {
    return this.post('GetTagList', { reponame, tag })
  }

  getNamespaceInfo(namespace) {
    return this.post('GetNamespaceInfo', { namespace, limit: 50 })
  }
}

exports.create = function () {
  return new Container()
}
