const Joi = require('joi')

function ValidationError(message) {
  this.name = 'ValidationError'
  this.message = message || ''
}
ValidationError.prototype = Object.create(Error.prototype);
ValidationError.prototype.constructor = ValidationError;

module.exports = function () {
  return function (ctx, next) {
    if (ctx.validate) {
      return next()
    }

    ctx.Joi = Joi

    ctx.validate = function (schema) {
      const target = ctx.method === 'GET' ? ctx.query : (ctx.request.body || {})
      const result = ctx.Joi.validate(target, schema)
      if (result.error) {
        throw new ValidationError(result.error.details[0] && result.error.details[0].message)
      }
    }
    return next()
  }
}
