const Router = require('koa-router')
const yaml = require('js-yaml')
const qs = require('querystring')
const templates = require('../serviceTemplate')

let newNsKey = ''

const router = new Router();
module.exports = router

const keepNamespace = ['default', 'kube-system']

router.get('/', async (ctx) => {
  const data = await ctx.cluster.namespace_get()
  data.namespaces = data.namespaces && data.namespaces.filter(item => !keepNamespace.includes(item.name))
  ctx.body = ctx.ok(data)
})

router.get('/get_namespace_for_jenkins', async (ctx) => {
  const data = await ctx.cluster.namespace_get()
  const ret = data.namespaces.map(item => item.name)
  ctx.body = ret.filter((item) => {
    if (!['default', 'kube-system'].includes(item)) {
      return item
    }
    return null
  }).join('\n')
})


router.get('/info', async (ctx) => {
  const data = await ctx.cluster.namespace_get()
  const ns = data.namespaces.find(item => item.name === qs.unescape(ctx.request.query.namespace))
  ctx.body = ctx.ok(ns)
})

router.post('/create', async (ctx) => {
  await ctx.cluster.namespace_create(ctx.request.body.name)
  // await ctx.cluster.ingress_create(ctx.request.body.name)
  ctx.body = ctx.ok()
})

const IMAGES = {
  zookeeper: 'zookeeper:3.4.10',
  rabbitmq: 'rabbitmq:3.6-management',
  mysql: 'mysql:5.7',
  redis: 'ccr.ccs.tencentyun.com/qa-db/redis:v4',
}

router.post('/init', async (ctx) => {
  const body = ctx.request.body

  // if (body.code !== newNsKey) {
  //   throw new Error('创建确认码不正确')
  // }

  await ctx.cluster.namespace_create(body.namespace)
  await ctx.cluster.ingress_create(body.namespace)

  async function serviceCreate(element, index) {
    if (index !== 'common') {
      const data = {
        namespace: body.namespace,
        image: `ccr.ccs.tencentyun.com/qa-${index}/${element}:latest`,
        type: index,
        serviceName: element,
        system_name: element,
      }
      const template = templates[index].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
        if (data[arguments[1]] === undefined) {
          throw new Error('缺少模板所需变量')
        }
        return data[arguments[1]]
      })
      const params = yaml.load(template)
      await ctx.cluster.service_create(params, index)
    }
    if (index === 'common') {
      const data = {
        namespace: body.namespace,
        image: IMAGES[element],
      }
      const template = templates[element].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
        if (data[arguments[1]] === undefined) {
          throw new Error('缺少模板所需变量')
        }
        return data[arguments[1]]
      })
      const params = yaml.load(template)
      await ctx.cluster.service_create(params)
    }
  }

  for (const index in body.systems) {
    if ({}.hasOwnProperty.call(body.systems, index)) {
      for (const item in body.systems[index]) {
        if ({}.hasOwnProperty.call(body.systems[index], item)) {
          serviceCreate(body.systems[index][item], index)
        }
      }
    }
  }

  ctx.body = ctx.ok('正在创建')
})

router.post('/delete', async (ctx) => {
  await ctx.cluster.namespace_delete(ctx.request.body.name)
  ctx.body = ctx.ok()
})

function generateUUID() {
  let d = new Date().getTime();
  const uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
    const r = (d + Math.random() * 16) % 16 | 0;
    d = Math.floor(d / 16);
    return (c === 'x' ? r : ((r & 0x3) | 0x8)).toString(16);
  });
  return uuid;
}

router.get('/get_code', async (ctx) => {
  newNsKey = newNsKey === '' ? generateUUID() : newNsKey
  ctx.body = ctx.ok(newNsKey)
})
