const schedule = require('node-schedule')
const _ = require('lodash')
const sleep = require('sleep')
const logger = require('koa-log4').getLogger('deployLatest')
const { serviceRestart, getServicesFormat, getAllNamespace } = require('../kubeService/service')
const container = require('../services/tke.containerService').create()
const getClient = require('../resource/getClient')

const clientNew = {}

const deploy = async (cluster) => {
  if (!clientNew[cluster]) {
    clientNew[cluster] = await getClient(cluster)
  }
  logger.info('deployLatest start')

  const ns = await getAllNamespace(clientNew[cluster])
  // for test
  // const testNamespace = ['fis', 'xyqb2']
  // const nsTest = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
  // for (const namespace of nsTest) {
  for (const namespace of ns.namespaces) {
    logger.info('开始检查ns:', namespace.name)

    const svcs = await getServicesFormat(clientNew[cluster], namespace.name)
    for (const svc of svcs) {
      if (svc.image.indexOf('latest') !== -1) {
        logger.info('检查项目', svc.image)
        const repoName = svc.image.split(':')[0].split('/').slice(1).join('/')
        const latest = await container.getTagByName(repoName, 'latest')
        const latestImageID = _.get(latest.tagInfo, '[0].tagId', '')
        if (svc.imageID.split('@')[1] !== latestImageID) {
          logger.info('latest不一致，部署项目', namespace.name, svc.podName)
          await serviceRestart(clientNew[cluster], namespace.name, svc.podName)
        }
        sleep.msleep(1000)
      }
    }
    logger.info('ns:', namespace.name, '检查完毕')
  }
  logger.info('deployLatest end')
}

module.exports = () => {
  // schedule.scheduleJob('*/2 * * * *', async () => {
  schedule.scheduleJob('0 2 * * *', async () => {
    try {
      await deploy('qa')
    } catch (e) {
      logger.info('deployLatest', e)
    }
  });
}
