const schedule = require('node-schedule')
const _ = require('lodash')
const logger = require('koa-log4').getLogger('deployLatest')
const {
  serviceRestart, getServicesFormat, getAllNamespace, deployUpdate,
} = require('../kubeService/service')
const container = require('../services/tke.containerService').create()
const getClient = require('../resource/getClient')
const dingTalk = require('../utils/dingTalk')
const sleep = require('../utils/sleep')
const APP_CONFIG = require('../config')
const makeResouce = require('./../resource/makeResouce')

const deploy = async (cluster) => {
  logger.info('deployLatest job start')
  const client = await getClient(cluster)
  const ns = await getAllNamespace(client.clientInfo)
  const summary = {}

  // // for test
  // const testNamespace = ['fe']
  // const nsTest = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
  // for (const namespace of nsTest) {
  for (const namespace of ns.namespaces) {
    logger.info('开始检查ns:', namespace.name)
    summary[namespace.name] = {
      latestArray: [],
      masterArray: [],
    }
    const svcs = await getServicesFormat(client.clientInfo, namespace.name)
    for (const svc of svcs) {
      // 重启latest
      if (~svc.image.indexOf('latest')) {
        logger.info('检查项目', namespace.name, svc.serviceName)
        try {
          const latest = await container.getTagByName(`qa-test/${svc.serviceName}`, 'latest')
          const latestImageID = _.get(latest.tagInfo, '[0].tagId', '')
          if (latestImageID && latestImageID !== svc.imageID.split('@')[1]) {
            logger.info('latest不一致，部署项目', namespace.name, svc.podName)
            summary[namespace.name].latestArray.push(svc.serviceName)
            await serviceRestart(client.clientInfo, namespace.name, svc.podName)
          }
        } catch (error) {
          logger.warn(svc.serviceName, error)
        }
        await sleep(5 * 1000)
      }

      // 把master更新部署成lastet
      if (~svc.image.search(':master-')) {
        logger.info('将master分支', svc.image, '部署成latest')
        let mock
        if (svc.labels.mock) {
          mock = `'${svc.labels.mock}'`
        }
        const data = {
          image: `qa-test/${svc.serviceName}:latest`,
          namespace: namespace.name,
          serviceName: svc.serviceName,
          type: svc.labels.type,
          label: svc.labels.type,
          mock,
        }
        const resources = await makeResouce(data.serviceName, data.label)
        data.resources = resources
        await deployUpdate(client.clusterInfo, client.clientInfo, data)
        summary[namespace.name].masterArray.push(svc.serviceName)
        await sleep(5 * 1000)
      }

      // // for op
      // if (svc.labels.type !== 'base') {
      //   logger.info('将qa-xxx', svc.image, '部署成qa-test')
      //   let mock
      //   if (svc.labels.mock) {
      //     mock = `'${svc.labels.mock}'`
      //   }
      //   const image = svc.image.split(':')[1]
      //   const data = {
      //     image: `qa-test/${svc.serviceName}:${image}`,
      //     namespace: namespace.name,
      //     serviceName: svc.serviceName,
      //     type: svc.labels.type,
      //     label: svc.labels.type,
      //     mock,
      //   }
      //   const resources = await makeResouce(data.serviceName, data.label)
      //   data.resources = resources
      //   await deployUpdate(client.clusterInfo, client.clientInfo, data)
      //   summary[namespace.name].masterArray.push(svc.serviceName)
      //   await sleep(5 * 1000)
      // }
    }

    logger.info('ns:', namespace.name, '检查完毕')
  }

  let text = ''
  for (const i in summary) {
    if (Object.prototype.hasOwnProperty.call(summary, i)) {
      if (summary[i].latestArray.length) {
        text = `${text}${i} 重新部署的 latest : ${summary[i].latestArray.join('、')}\n\n`
      }
      if (summary[i].masterArray.length) {
        text = `${text}${i} 重新部署的 master : ${summary[i].masterArray.join('、')}\n\n`
      }
    }
  }
  dingTalk('daily latest 部署结果', text, APP_CONFIG.latestDingRobot)
  logger.info('deployLatest job end')
}

module.exports = () => {
  // schedule.scheduleJob('*/2 * * * *', async () => {
  schedule.scheduleJob('0 8 * * *', async () => {
    try {
      await deploy('qa')
    } catch (e) {
      logger.info('deployLatest', e)
    }
  });
}
