const getClient = require('../../resource/getClient')

module.exports = function client() {
  return async function (ctx, next) {
    const exclude = [
      '/service/listEnvVarsNew',
      '/service/listEnvVars',
      '/service/test',
      '/cluster',
      '/repository',
      '/repository/getTags',
      '/repository/getNamespaceInfo',
    ]
    if (exclude.includes(ctx.path)) {
      await next()
    } else {
      const cluster = ctx.request.headers.cluster
      const client = await getClient(cluster)
      ctx.client = client.clientInfo
      ctx.cluterParams = client.clusterInfo
      await next()
    }
  }
}
