const Router = require('koa-router')
const yaml = require('js-yaml')
const templates = require('../serviceTemplate')

const TYPES = ['ui', 'java', 'node', 'python', 'go']

const router = new Router()
module.exports = router

router.get('/', async ctx => {
    let data = await ctx.cluster.service_list(ctx.query.namespace)
    ctx.body = ctx.ok(data)
})

router.post('/create', async ctx => {
    let {type, serviceName, namespace, image, system_name, lable} = ctx.request.body
    if (!TYPES.includes(type)) {
        return ctx.body = ctx.fail('不支持的服务类型')
    }
    let data = {
        serviceName,
        namespace,
        image,
        system_name,
        lable
    }
    if (!system_name) {
        // ui abTest的时候不一样
        data.system_name = serviceName
    }
    let template = templates[type].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
        if (data[arguments[1]] === undefined) {
            throw new Error('缺少模板所需变量')
        }
        return data[arguments[1]]
    })
    let params = yaml.load(template)
    await ctx.cluster.service_create(params, type)
    ctx.body = ctx.ok('创建成功')
})
router.post('/details', async ctx => {
    let data = await ctx.cluster.service_get(ctx.request.body.serviceName, ctx.request.body.namespace)
    ctx.body = ctx.ok(data)
})
router.post('/delete', async ctx => {
    await ctx.cluster.service_delete(ctx.request.body.serviceName, ctx.request.body.namespace)
    ctx.body = ctx.ok('删除成功')
})

router.post('/modifyImage', async ctx => {
    await ctx.cluster.service_modifyImage(ctx.request.body.serviceName, ctx.request.body.image, ctx.request.body.namespace)
    ctx.body = ctx.ok('更新成功')
})
