const { defaultConfig } = require('../resource/resourceLimit')
const awaitRequest = require('../utils/awaitRequest')

// 资源限制
module.exports = async (serviceName, type) => {
  let resources = defaultConfig[type]

  const res = await awaitRequest({
    url: `http://qaapi.liangkebang.com/proconfig/getK8sConf?project_name=${serviceName}`,
    method: 'get',
  })
  const mongoResouces = JSON.parse(res.body).data
  if (mongoResouces && mongoResouces.memLimit) {
    resources = mongoResouces
  }

  return resources
}
