const schedule = require('node-schedule')
const sleep = require('sleep')
const logger = require('koa-log4').getLogger('dailySyncDB')
const {
  getServicesFormat, getAllNamespace,
} = require('../kubeService/service')
const getClient = require('../resource/getClient')
const awaitRequest = require('../utils/awaitRequest')

const syncDB = async (cluster) => {
  logger.info('dailySyncDB start')
  const client = (await getClient(cluster)).clientInfo
  const ns = await getAllNamespace(client)

  // for test
  const testNamespace = ['fis', 'arch']
  const nsTest = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
  for (const namespace of nsTest) {
    // for (const namespace of ns.namespaces) {

    const svcs = await getServicesFormat(client, namespace.name)
    for (const svc of svcs) {
      if (svc.serviceName === 'mysql') {
        const data = {
          dbname: 'all(no_mall)',
          mysqlName: 'mysql',
          namespace: namespace.name,
          not_delete_business_data: true,
          use_cache: true,
        }

        const res = await awaitRequest({
          url: 'http://qaapi.liangkebang.com/dbsync/tke',
          method: 'post',
          body: JSON.stringify(data),
        })

        if (JSON.parse(res.body).code === '0000') {
          logger.info('开始同步ns:', namespace.name)
        } else {
          logger.info('同步ns失败:', namespace.name, JSON.parse(res.body).data)
        }
        sleep.msleep(2 * 1000)
        break
      }
    }
  }
  logger.info('dailySyncDB end')
}

module.exports = () => {
  schedule.scheduleJob('*/2 * * * *', async () => {
  // schedule.scheduleJob('0 2 * * *', async () => {
    try {
      await syncDB('qa')
    } catch (e) {
      logger.info('dailySyncDB', e)
    }
  });
}
