const Router = require('koa-router')
const logger = require('koa-log4').getLogger('router:namespace');

const router = new Router();
module.exports = router
router.get('/', async (ctx) => {
  logger.info('hello')
  const data = await ctx.cluster.namespace_get()
  ctx.body = ctx.ok(data)
})

router.post('/create', async (ctx) => {
  await ctx.cluster.namespace_create(ctx.request.body.name)
  await ctx.cluster.ingress_create(ctx.request.body.name)
  ctx.body = ctx.ok()
})

router.post('/delete', async (ctx) => {
  await ctx.cluster.namespace_delete(ctx.request.body.name)
  ctx.body = ctx.ok()
})
