const Router = require('koa-router')
const yaml = require('js-yaml')
const templates = require('../serviceTemplate')

const IMAGES = ['zookeeper:3.4.10']

const router = new Router()
module.exports = router

router.post('/create', async ctx => {
  let data = {
    namespace: ctx.request.body.namespace,
    image: IMAGES[0]
  }
  let template = templates['zookeeper'].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
    if (data[arguments[1]] === undefined) {
      throw new Error('缺少模板所需变量')
    }
    return data[arguments[1]]
  })
  let params = yaml.load(template)
  await ctx.client.service_create(params)
  ctx.body = ctx.ok('创建成功')
})

router.post('/delete', async ctx => {
  await ctx.client.service_delete('zookeeper', ctx.request.body.namespace)
  ctx.body = ctx.ok('删除成功')
})
