
const logger = require('log4js').getLogger('error')

module.exports = function () {
  return async function (ctx, next) {
    try {
      await next()
    } catch (e) {
      let msg = '系统出错了哦，请稍后再试。'
      // mongo 唯一索引冲突
      if (e.name === 'MongoError') {
        msg = e.errmsg
      } else if (e.message) {
        msg = e.message
      }

      logger.error(ctx.path)
      logger.error(e)
      ctx.respond = true
      ctx.status = 200
      ctx.body = {
        code: '0001',
        msg,
      }
    }
  }
}
