const { defaultConfig } = require('../resource/resourceLimit')
const awaitRequest = require('../utils/awaitRequest')
const APP_CONFIG = require('../config')

// 资源限制
module.exports = async (serviceName, type) => {
  let resources = defaultConfig[type]

  const res = await awaitRequest({
    url: `${APP_CONFIG.qaapiHost}/proconfig/getK8sConf?project_name=${serviceName}`,
    method: 'get',
  })
  const mongoResouces = res.data
  if (mongoResouces && mongoResouces.memLimit) {
    resources = mongoResouces
  }

  return resources
}
