const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config
const awaitRequest = require('../utils/awaitRequest')

module.exports = async function getClient(cluster) {
  const res = await awaitRequest({
    url: `http://127.0.0.1:3003/cluster/list?clusterName=${cluster}`,
    method: 'get',
  })
  const ca = JSON.parse(res.body).data[0]
  return new Client({
    config: config.fromKubeconfig(ca.clusterCA),
    version: '1.10',
  })
}
