/* eslint-disable no-multi-assign */
const defaultMysql = {
  memory: {
    request: 1024,
    limit: 1024,
  },
  cpu: {
    request: 200,
    limit: 2000,
  },
}

const defaultRabbitmq = {
  memory: {
    request: 1500,
    limit: 1500,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultZookeeper = {
  memory: {
    request: 300,
    limit: 300,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultRedis = {
  memory: {
    request: 100,
    limit: 100,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const projectConfig = {}

const memoryV1 = {
  request: 50,
  limit: 50,
}

const memoryV2 = {
  request: 200,
  limit: 240,
}

const memoryV2P = {
  request: 500,
  limit: 600,
}

const memoryV3 = {
  request: 800,
  limit: 1000,
}

const memoryV4 = {
  request: 1200,
  limit: 1500,
}

const cpuV1 = {
  request: 10,
  limit: 100,
}

const cpuV2 = {
  request: 20,
  limit: 200,
}

const cpuV3 = {
  request: 100,
  limit: 1000,
}

const cpuV4 = {
  request: 200,
  limit: 2000,
}

const defaultUI = {
  memory: memoryV1,
  cpu: cpuV1,
}

projectConfig['quantcube-ui'] = {
  memory: memoryV1,
  cpu: cpuV3,
}

const defaultNodejs = {
  memory: memoryV2,
  cpu: cpuV2,
}

const defaultPython = {
  memory: memoryV2,
  cpu: cpuV2,
}

const defaultJava = {
  memory: memoryV2P,
  cpu: cpuV3,
}

projectConfig.baitiao = projectConfig['smart-recruitment'] = {
  memory: memoryV3,
  cpu: cpuV3,
}

projectConfig['cash-loan-flow'] = projectConfig['gu-bei'] = projectConfig['merchant-backend'] = projectConfig['xyqb-mall'] = projectConfig.xyqb = {
  memory: memoryV3,
  cpu: cpuV4,
}

// vcc项目
projectConfig.talos = projectConfig['acs-service'] = projectConfig['acs-quartz'] = {
  memory: memoryV3,
  cpu: cpuV4,
}

// clotho启动比较耗时
projectConfig['urge-dispatcher'] = projectConfig.clotho = {
  memory: memoryV4,
  cpu: cpuV4,
}

projectConfig['smart-recruitment-spyder'] = {
  memory: memoryV4,
  cpu: cpuV3,
}

exports.projectConfig = projectConfig
exports.defaultConfig = {
  java: defaultJava,
  ui: defaultUI,
  node: defaultNodejs,
  redis: defaultRedis,
  'redis-sentinel': defaultRedis,
  zookeeper: defaultZookeeper,
  mysql: defaultMysql,
  rabbitmq: defaultRabbitmq,
  python: defaultPython,
}
