const logger = require('koa-log4').getLogger('ingressHandle')

const getManifest = (namespace, servicename, doamin, clusterDomain, port) => ({
  apiVersion: 'extensions/v1beta1',
  kind: 'Ingress',
  metadata: {
    name: servicename,
    namespace,
    annotations: {
      'kubernetes.io/ingress.class': 'traefik',
    },
  },
  spec: {
    rules: [
      {
        host: `${doamin}-${namespace}.${clusterDomain}`,
        http: {
          paths: [
            {
              path: '/',
              backend: {
                serviceName: `${servicename}`.replace('-2', ''),
                servicePort: port,
              },
            },
          ],
        },
      },
    ],
  },
})
const ingressGet = async (client, namespace, servicename) => client.apis.extensions.v1beta1.namespaces(namespace)
  .ingresses(servicename).get()

const ingressCreate = async (client, namespace, servicename, doamin, clusterDomain, port) => {
  const Manifest = getManifest(namespace, servicename, doamin, clusterDomain, port)
  logger.info('创建ingress', JSON.stringify(Manifest))
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses
    .post({ body: Manifest })
}
const ingressUpdate = async (client, namespace, servicename, host, clusterDomain) => {
  const Manifest = getManifest(namespace, servicename, clusterDomain)
  Manifest.spec.rules[0].host = host
  logger.info('更新ingress', Manifest)
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses(servicename)
    .patch({ body: Manifest })
}
const ingressDelete = async (client, namespace, servicename) => {
  try {
    logger.info('删除ingress', namespace, servicename)
    await client.apis.extensions.v1beta1.namespaces(namespace).ingresses(servicename).delete()
  } catch (error) {
    logger.warn(error.toString())
  }
}
module.exports = {
  ingressGet,
  ingressCreate,
  ingressUpdate,
  ingressDelete,
}
