const schedule = require('node-schedule')
const _ = require('lodash')
const sleep = require('sleep')
const logger = require('koa-log4').getLogger('deployLatest')
const {
  serviceRestart, getServicesFormat, getAllNamespace, deployUpdate,
} = require('../kubeService/service')
const container = require('../services/tke.containerService').create()
const getClient = require('../resource/getClient')
const dingTalk = require('../utils/dingTalk')
const makeResouce = require('./../resource/makeResouce')

const address = 'https://oapi.dingtalk.com/robot/send?access_token=99e801a2cf26680e6ce09cb12f830c21a03ae3df07d18f6a38e1db54c0e95f2c'

const deploy = async (cluster) => {
  logger.info('deployLatest start')
  const client = await getClient(cluster)
  const ns = await getAllNamespace(client.clientInfo)

  // // for test
  // const testNamespace = ['ka3']
  // const nsTest = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
  // for (const namespace of nsTest) {
  for (const namespace of ns.namespaces) {
    logger.info('开始检查ns:', namespace.name)
    const latestArray = []
    const masterArray = []

    const svcs = await getServicesFormat(client.clientInfo, namespace.name)
    for (const svc of svcs) {
      // 重启latest
      if (~svc.image.indexOf('latest')) {
        logger.info('检查项目', namespace.name, svc.serviceName)
        const repoName = svc.image.split(':')[0].split('/').slice(1).join('/')
        const latest = await container.getTagByName(repoName, 'latest')
        const latestImageID = _.get(latest.tagInfo, '[0].tagId', '')
        if (svc.imageID.split('@')[1] !== latestImageID) {
          logger.info('latest不一致，部署项目', namespace.name, svc.podName)
          latestArray.push(svc.image.split('/')[2])
          await serviceRestart(client.clientInfo, namespace.name, svc.podName)
        }
        sleep.msleep(5 * 1000)
      }
      // 把master更新部署成lastet
      if (~svc.image.search(':master-')) {
        logger.info('将master分支', svc.image, '部署成latest')
        const repoName = svc.image.split(':')[0].split('/').slice(1).join('/')
        let mock
        if (svc.labels.mock) {
          mock = `'${svc.labels.mock}'`
        }
        const data = {
          image: `${repoName}:latest`,
          namespace: namespace.name,
          serviceName: svc.serviceName,
          type: svc.labels.type,
          label: svc.labels.type,
          mock,
        }
        const resources = await makeResouce(data.serviceName, data.label)
        data.resources = resources
        await deployUpdate(client.clusterInfo, client.clientInfo, data)
        masterArray.push(svc.image.split('/')[2])
        sleep.msleep(5 * 1000)
      }
    }
    const text = `namespace : ${namespace.name}\n\n`
      + `重新部署的latest : \n\n${latestArray.join('\n\n')}\n\n`
      + `重新部署的master : \n\n${masterArray.join('\n\n')}`
    dingTalk(`${namespace.name} latest 部署结果`, text, address)
    logger.info('ns:', namespace.name, '检查完毕')
  }
  logger.info('deployLatest end')
}

module.exports = () => {
  // schedule.scheduleJob('*/4 * * * *', async () => {
  schedule.scheduleJob('0 3 * * *', async () => {
    try {
      await deploy('qa')
    } catch (e) {
      logger.info('deployLatest', e)
    }
  });
}
