const Router = require('koa-router')
const yaml = require('js-yaml')
const templates = require('../serviceTemplate')

const IMAGES = {
  zookeeper: 'zookeeper:3.4.10',
  rabbitmq: 'rabbitmq:3.6-management',
  mysql: 'mysql:5.7',
}

const router = new Router()
module.exports = router

router.post('/create', async (ctx) => {
  const { serviceName, namespace } = ctx.request.body
  if (!Object.keys(IMAGES).includes(serviceName)) {
    ctx.body = ctx.fail('不支持的服务类型')
    return
  }

  const data = {
    namespace,
    image: IMAGES[serviceName],
  }
  const template = templates[serviceName].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
    if (data[arguments[1]] === undefined) {
      throw new Error('缺少模板所需变量')
    }
    return data[arguments[1]]
  })
  const params = yaml.load(template)
  await ctx.client.service_create(params)
  ctx.body = ctx.ok('创建成功')
})

router.post('/delete', async (ctx) => {
  const { serviceName, namespace } = ctx.request.body
  await ctx.client.service_delete(serviceName, namespace)
  ctx.body = ctx.ok('删除成功')
})
