

const Code = require('./code')

module.exports = function () {
  return async function (ctx, next) {
    if (ctx.ok || ctx.fail) return next()

    ctx.ok = function (data = {}) {
      return {
        code: '0000',
        data,
      }
    }

    ctx.Code = Code

    ctx.fail = function (msg, code) {
      if (msg && msg.code) {
        return msg
      }

      return {
        code: code || '0001',
        msg: msg || '请求失败，请稍候重试',
      }
    }

    return next()
  }
}
