const logger = require('koa-log4').getLogger('dingtalk')
const awaitRequest = require('./awaitRequest')

module.exports = async (title, text, url) => {
  const dingData = {
    msgtype: 'markdown',
    markdown: {
      title,
      text,
    },
  }
  if (url && text) {
    await awaitRequest({
      url,
      method: 'POST',
      headers: {
        'Content-Type': 'application/json;charset=utf-8',
      },
      body: JSON.stringify(dingData),
    })
    logger.info(`发送 dingtalk ${JSON.stringify(dingData)}`)
  }
}
