const path = require('path');

const logPath = path.resolve(__dirname, '../logs');
// const layout = { type: 'pattern', pattern: '%d{yyyy-MM-dd hh:mm:ss.SSS} %p %c %m%n' };

module.exports = {
  log4js: {
    path: logPath,
    conf: {
      appenders: {
        default: { type: 'console' },
        file: {
          type: 'dateFile',
          filename: `${logPath}/sys-api.log`,
          pattern: '.yyyy-MM-dd',
          keepFileExt: true,
        },
      },
      categories: {
        default: { appenders: ['default', 'file'], level: 'info' },
        file: { appenders: ['file'], level: 'info' },
      },
    },
  },
};
