// 判断输入的15位或者18位身份证号码是否合法
function ParseID(pId) {
  const arrVerifyCode = [1, 0, 'x', 9, 8, 7, 6, 5, 4, 3, 2];
  const wi = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];

  if (pId.length !== 15 && pId.length !== 18) {
    return ('身份证号码只能是15位或18位!');
  }

  let ai = (pId.length === 18) ? pId.substr(0, 17) : `${pId.substr(0, 6)}19${pId.substr(6)}`;

  if (!/^\d+$/.test(ai)) {
    return ('身份证除最后一位外，必须为数字！');
  }

  const yyyy = ai.substr(6, 4);
  const mm = ai.substr(10, 2) - 1;
  const dd = ai.substr(12, 2);
  const d = new Date(yyyy, mm, dd);
  const year = d.getFullYear();
  const mon = d.getMonth();
  const day = d.getDate();
  const now = new Date();

  if (year != yyyy || mon != mm || day != dd || d > now || now.getFullYear() - year > 140) {
    return ('身份证出生年月日输入错误！');
  }

  let ret = 0;
  for (let i = 0; i < 17; i += 1) {
    ret += ai.charAt(i) * wi[i];
  }
  ai += arrVerifyCode[ret %= 11];
  return ((pId.length === 18 && pId.toLowerCase() !== ai) ? `身份证输入错误，正确的为\n${ai}！` : ai);
}

// luhn校验规则：16位银行卡号（19位通用）:
// 1.将未带校验位的 15（或18）位卡号从右依次编号 1 到 15（18），位于奇数位号上的数字乘以 2。
// 2.将奇位乘积的个十位全部相加，再加上所有偶数位上的数字。
// 3.将加法和加上校验位能被 10 整除。
function luhnCheck(_bankNo) {
  const bankNo = `${_bankNo}`;
  if (!(bankNo.length === 16 || bankNo.length === 19)) {
    return `卡号位数不正确：${_bankNo}`;
  }

  // 取出最后一位（与luhn进行比较）
  const lastNum = bankNo.substr(bankNo.length - 1, 1);

  // 前15或18位
  const first15Num = bankNo.substr(0, bankNo.length - 1);
  const newArr = [];

  // 前15或18位倒序存进数组
  for (let i = first15Num.length - 1; i > -1; i -= 1) {
    newArr.push(parseInt(first15Num.substr(i, 1), 10));
  }

  // 奇数位*2的积 <9
  const arrJiShu = [];

  // 奇数位*2的积 >9
  const arrJiShu2 = [];

  // 偶数位数组
  const arrOuShu = [];

  for (let i = 0; i < newArr.length; i += 1) {
    if ((i + 1) % 2 === 1) {
      if (newArr[i] * 2 < 9) {
        arrJiShu.push(newArr[i] * 2);
      } else {
        arrJiShu2.push(newArr[i] * 2);
      }
    } else {
      arrOuShu.push(newArr[i]);
    }
  }

  // 奇数位*2 >9 的分割之后的数组个位数
  const jishuChildOne = [];

  // 奇数位*2 >9 的分割之后的数组十位数
  const jishuChileTwo = [];

  arrJiShu2.forEach((item) => {
    jishuChildOne.push(item % 10);
    jishuChileTwo.push(parseInt(item / 10, 10));
  });

  // 奇数位*2 < 9 的数组之和
  const sumJiShu = arrJiShu.reduce((x, y) => x + y, 0);

  // 偶数位数组之和
  const sumOuShu = arrOuShu.reduce((x, y) => x + y, 0);

  // 奇数位*2 >9 的分割之后的数组个位数之和
  const sumJiShuChild1 = jishuChildOne.reduce((x, y) => x + y, 0);

  // 奇数位*2 >9 的分割之后的数组十位数之和
  const sumJiShuChild2 = jishuChileTwo.reduce((x, y) => x + y, 0);

  // 计算总和
  const sumTotal = sumJiShu + sumOuShu + sumJiShuChild1 + sumJiShuChild2;

  // 计算luhn值
  const k = sumTotal % 10 === 0 ? 10 : sumTotal % 10;
  const luhn = `${10 - k}`;

  if (lastNum === luhn) {
    return true;
  }
  return false;
}


module.exports = {
  ParseID,
  luhnCheck,
};
