const bankID = require('../services/bankID');
const IDCard = require('../services/IDCard');
const mobile = require('../services/mobile');
const address = require('../services/address');
const name = require('../services/name');
const email = require('../services/email');
const checkService = require('../services/checkService');

// 生成银行卡
async function getBankID(ctx) {
  let { bank } = ctx.query;
  bank = bank ? bank.toUpperCase() : bankID.randomBank();
  ctx.body = { code: '0000', data: [bankID.RandomCreateBankID(bank)] };
}

// 获取银行列表
const getBankList = async (ctx) => {
  ctx.body = { code: '0000', data: bankID.bankList() };
};

async function getProvinceList(ctx) {
  ctx.body = address.allProvince();
}

async function getCountyList(ctx) {
  ctx.body = address.allCounty();
}

// 生成随机手机号
async function getMoble(ctx) {
  ctx.body = { mobile: mobile.getMoble() };
}

// 生成地址
async function getAddress(ctx) {
  ctx.body = { address: address.address() };
}

// 生成名字
async function getName(ctx) {
  ctx.body = { name: name.getName() };
}

// 生成电子邮箱
async function getEmail(ctx) {
  ctx.body = { email: email.email() };
}

// 生成身份证
async function getID(ctx) {
  const province = ctx.query.province || address.province();
  const city = address.city(province);
  const county = address.county(province, city);
  ctx.body = {
    IDCardNo: IDCard.randomCreateID(county.code),
    province,
    city,
    county: county.name,
  };
}

// 生成所有
async function getAll(ctx) {
  const { bank } = ctx.query;
  const count = ctx.query.count || 1;
  const re = [];
  for (let i = 0; i < count; i += 1) {
    const province = ctx.query.province ? address.allProvince()
      .filter(item => item.indexOf(ctx.query.province) !== -1)[0] : address.province();
    const city = address.city(province);
    const county = address.county(province, city);
    const fullAddress = province + city + county.name;
    const ID = IDCard.randomCreateID(county.code);
    const item = {
      name: name.getName(),
      IDCardNo: ID,
      sex: IDCard.getSex(ID),
      birthday: IDCard.getBirthday(ID),
      address: fullAddress + address.streetAddress(),
      mobile: mobile.getMoble(),
      email: email.email(),
    };
    Object.assign(item, bankID.RandomCreateBankID(bank));
    re.push(item);
  }
  ctx.body = { code: '0000', count: re.length, data: re };
}

async function checkID(ctx) {
  const ID = ctx.query.id || ctx.query.ID;
  ctx.body = { data: checkService.ParseID(ID) };
}

async function chekBankCardID(ctx) {
  const ID = ctx.query.id || ctx.query.ID;
  ctx.body = { data: checkService.luhnCheck(ID) };
}

module.exports = {
  'GET /testdata/getID': getID,
  'GET /testdata/getAll': getAll,
  'GET /testdata/getEmail': getEmail,
  'GET /testdata/getName': getName,
  'GET /testdata/getAddress': getAddress,
  'GET /testdata/getBankID': getBankID,
  'GET /testdata/getMoble': getMoble,
  'GET /testdata/getBankList': getBankList,
  'GET /testdata/getProvinceList': getProvinceList,
  'GET /testdata/getCountyList': getCountyList,
  'GET /testdata/checkID': checkID,
  'GET /testdata/chekBankCardID': chekBankCardID,
};
