const _ = require('lodash');
const random = require('./random');
const helpers = require('./helpers');
const allData = require('./mockz').data;

// 全部数据
const allCounty = () => allData;

// 全部省份
const allProvince = () => allData.map(item => item.name);

// 省级
const province = () => {
  const idx = _.random(allData.length - 1);
  return allData[idx].name;
};

// 市级
const city = (provName) => {
  const pArr = _.filter(allData, { name: provName });

  let prov;
  if (pArr.length > 0) {
    [prov] = pArr;
  } else {
    const pidx = _.random(allData.length - 1);
    prov = allData[pidx];
  }

  const cidx = _.random(prov.children.length - 1);

  return prov.children[cidx].name;
};

// 县级
const county = (provName, cityName) => {
  const pidx = _.random(allData.length - 1);
  let prov = allData[pidx];
  const pArr = _.filter(allData, { name: provName });
  if (pArr.length > 0) {
    [prov] = pArr;
  }
  const cidx = _.random(prov.children.length - 1);
  let ct = prov.children[cidx];

  const cArr = _.filter(prov.children, { name: cityName });
  if (cArr.length > 0) {
    [ct] = cArr;
  }

  const idx = _.random(ct.children.length - 1);
  return ct.children[idx];
};

function secondaryAddress() {
  return helpers.replaceSymbolWithNumber(random.array_element(
    [
      '##栋#0#屋',
      '##号楼#门#0#',
      '#排#0#室',
    ],
  ));
}

function streetName() {
  let result;
  switch (random.number(2)) {
    case 0:
      result = random.first_name() + random.street_suffix();
      break;
    case 1:
      result = `${random.first_name().substr(1, 1)}${random.last_name().substr(0, 1)}${random.street_suffix()}`;
      break;
    default:
  }
  return result;
}

function streetAddress() {
  let address = '';
  switch (random.number(3)) {
    case 0:
      address = `${streetName() + helpers.replaceSymbolWithNumber('###')}号${random.last_name()}${random.last_name()}小区`;
      break;
    case 1:
      address = `${streetName() + helpers.replaceSymbolWithNumber('##')}号${random.first_name()}苑`;
      break;
    default:
      address = `${streetName() + helpers.replaceSymbolWithNumber('#')}号院`;
      break;
  }
  return address + secondaryAddress();
}

// 地址
const address = () => {
  const pidx = _.random(allData.length - 1);
  const prov = allData[pidx];
  const cidx = _.random(prov.children.length - 1);
  const ct = prov.children[cidx];
  const cyidx = _.random(ct.children.length - 1);
  const cy = ct.children[cyidx];

  return `${prov.name}${ct.name}${cy.name}${streetAddress()}`;
};


module.exports = {
  address,
  province,
  city,
  county,
  streetAddress,
  allProvince,
  allCounty,
};
