const Random = require('./random');
const Helpers = require('./helpers');

const getEmail = {
  email() {
    return `${Helpers.slugify(this.userName())}@${Helpers.slugify(this.domainName())}`;
  },

  userName() {
    let result;
    switch (Random.number(2)) {
      case 0:
        result = Random.first_name();
        break;
      default:
        result = Random.first_name() + Random.array_element(['.', '_']) + Random.last_name();
        break;
    }
    return result;
  },

  domainName() {
    return `${this.domainWord()}.${Random.domain_suffix()}`;
  },

  domainWord() {
    return Random.first_name().toLowerCase();
  },

  ip() {
    const randNum = () => (Math.random() * 254 + 1).toFixed(0);

    const result = [];
    for (let i = 0; i < 4; i += 1) {
      result[i] = randNum();
    }

    return result.join('.');
  },
};

module.exports = getEmail;
