const Koa = require('koa');
const path = require('path');
const cors = require('kcors');
const log4js = require('koa-log4');
const favicon = require('koa-favicon');
const controller = require('./app/controller');
// const Middles = require('./middleware');
global.config = require('./config/app.conf');

const { config } = global;
const faviconPath = path.resolve(__dirname, './public/favicon.ico');
const logFormat = ':remote-addr - - ":method :url HTTP/:http-version" :status :content-length ":referrer" ":user-agent" :response-time ms';
const app = new Koa();
const logDir = path.join(__dirname, 'logs');

log4js.configure(config.log4js.conf, { cwd: logDir });

app.use(favicon(faviconPath))
  .use(log4js.koaLogger(log4js.getLogger('http'), { level: 'auto', format: logFormat }))
  .use(cors({
    maxAge: 86400, // options请求缓存24小时
    origin(req) {
      return req.header.origin;
    },
  }))
  // .use(Middles.router(app, { root: './app/controller' }))
  .use(controller());

app.listen(3333);
