const pinyin = require('pinyin');
const _ = require('lodash');

// parses string for a symbol and replace it with a random number from 1-10
exports.replaceSymbolWithNumber = (string, _symbol) => {
  // default symbol is '#'
  const symbol = _symbol || '#';

  return string.split('').map((item) => {
    if (item === symbol) {
      return _.random(1, 9);
    }

    return item;
  }).join('');
};

// slugifies string
exports.slugify = string => pinyin(string)
  .join('')
  .toLowerCase()
  .replace(/ /g, '-')
  .replace(/[^\w.-]+/g, '');
