// const checkService = require('./checkService')
const _ = require('lodash');
const address = require('./address');

// 根据15位身份证或者18位身份证的前17位生成18位身份证号码
function getCheckID(_pid) {
  const arrVerifyCode = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
  const wi = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
  if (_pid.length !== 15 && _pid.length !== 17) return (false);
  let ai = (_pid.length === 17) ? _pid : `${_pid.substr(0, 6)}19${_pid.substr(6)}`;
  if (!/^\d+$/.test(ai)) {
    return (false);
  }
  const yyyy = parseInt(ai.substr(6, 4), 10);
  const mm = parseInt(ai.substr(10, 2) - 1, 10);
  const dd = parseInt(ai.substr(12, 2), 10);
  const d = new Date(yyyy, mm, dd); const year = d.getFullYear();
  const mon = d.getMonth(); const day = d.getDate(); const now = new Date();
  if (year !== yyyy || mon !== mm || day !== dd || d > now || now.getFullYear() - year > 140) {
    return (false);
  }
  let ret = 0;
  for (let i = 0; i < 17; i += 1) {
    ret += ai.charAt(i) * wi[i];
  }
  ai += arrVerifyCode[ret %= 11];
  return (ai);
}

// 随机生成一个身份证
function randomCreateID(_countyCode) {
  let ff = false;
  const countyCode = parseInt(_countyCode, 10) && _countyCode.length === 12
    ? _countyCode.substr(0, 6) : address.county().code.substr(0, 6);

  while (!ff) {
    let yyyy = 0; let mm = 0; let dd = 0; let rnd = 0;

    yyyy = _.random(1960, 1990); mm = _.random(1, 12); dd = _.random(1, 31);
    rnd = `${_.random(0, 9)}${_.random(0, 9)}${_.random(0, 9)}`;
    if ((mm === 2) && (dd > 28)) {
      dd = _.random(1, 28);
    }
    if (((mm === 4) || (mm === 6) || (mm === 9) || (mm === 11)) && (dd === 31)) {
      dd -= 1;
    }
    mm = (mm < 10) ? (`0${mm}`) : mm;
    dd = (dd < 10) ? (`0${dd}`) : dd;
    const re = `${countyCode}${yyyy}${mm}${dd}${rnd}`;
    ff = getCheckID(re);
  }

  return ff;
}


function getBirthday(_id) {
  // let _id = checkService.ParseID(pid);
  const id = `${_id}`;
  if (id.length < 17) return 0;
  const birthday = (new Date(id.substr(6, 4), id.substr(10, 2) - 1, id.substr(12, 2)))
    .toLocaleDateString();
  return birthday;
}

function getSex(_id) {
  // let _id = checkService.ParseID(pid);
  const id = _id.toString();
  if (id.length < 17) return 0;
  const sex = _id.substr(16, 1) % 2 ? '男' : '女';
  return sex;
}

module.exports = {
  randomCreateID,
  getBirthday,
  getSex,
};
