const bankID = require('../services/bankID');
const IDCard = require('../services/IDCard');
const mobile = require('../services/mobile');
// const createNameService = require('../services/CreateNameService')
const address = require('../services/address');
const name = require('../services/name');
const email = require('../services/email');

exports.createBankID = async () => {
  const req = this.query;
  let { bank } = req;
  bank = bank ? bank.toUpperCase() : bankID.randomBank();
  this.body = { code: '0000', bank: bankID.RandomCreateBankID(bank) };
};

// 获取银行列表
exports.getBankList = async function () {
  this.body = bankID.bankList();
};

// 生成随机手机号
exports.getMoble = async function () {
  this.body = { mobile: mobile.getMoble() };
};

// 生成地址
exports.getAddress = async function () {
  const { province } = this.query;
  this.body = { address: address.fullAddress(province) };
};

// 生成名字
exports.getName = async function () {
  this.body = { name: name.getName() };
};

// 生成电子邮箱
exports.getEmail = async function () {
  this.body = { email: email.email() };
};

exports.getID = async function () {
  this.body = { IDCardNo: IDCard.RandomCreateID() };
};

exports.getAll = async function () {
  const { province, bank } = this.query;
  const count = this.query.count || 1;
  const re = [];
  for (let i = 0; i < count; i += 1) {
    const ID = IDCard.RandomCreateID(province);
    const item = {
      name: name.getName(),
      IDCardNo: ID,
      sex: IDCard.getSex(ID),
      birthday: IDCard.getBirthday(ID),
      address: address.fullAddress(province),
      mobile: mobile.getMoble(),
      email: email.email(),
    };
    Object.assign(item, bankID.RandomCreateBankID(bank));
    re.push(item);
  }
  this.body = { code: '0000', data: re };
};
