const definitions = require('./definitions');

const random = {
  // returns a single random number based on a range
  number(range) {
    return Math.floor(Math.random() * range);
  },

  // 生成一定范围的随机数
  randomBy(under, over) {
    switch (arguments.length) {
      case 1:
        return parseInt(Math.random() * under + 1, 10);
      case 2:
        return parseInt(Math.random() * (over - under + 1) + under, 10);
      default:
        return 0;
    }
  },

  // takes an array and returns the array randomly sorted
  array_element(array) {
    const r = Math.floor(Math.random() * array.length);
    return array[r];
  },

  city_prefix() {
    return this.array_element(definitions.city_prefix);
  },

  city_suffix() {
    return this.array_element(definitions.city_suffix);
  },

  street_suffix() {
    return this.array_element(definitions.street_suffix);
  },

  br_state() {
    return this.array_element(definitions.br_state);
  },

  br_state_abbr() {
    return this.array_element(definitions.br_state_abbr);
  },

  cn_state() {
    return this.array_element(definitions.cn_state);
  },

  cn_city(filter) {
    return this.array_element(definitions.cn_city.filter(item => item.indexOf(filter || '') !== -1));
  },

  cn_state_abbr() {
    return this.array_element(definitions.cn_state_abbr);
  },

  uk_county() {
    return this.array_element(definitions.uk_county);
  },

  uk_country() {
    return this.array_element(definitions.uk_country);
  },

  first_name() {
    return this.array_element(definitions.first_name);
  },

  last_name() {
    return this.array_element(definitions.last_name);
  },

  name_prefix() {
    return this.array_element(definitions.name_prefix);
  },

  name_suffix() {
    return this.array_element(definitions.name_suffix);
  },

  catch_phrase_adjective() {
    return this.array_element(definitions.catch_phrase_adjective);
  },

  catch_phrase_descriptor() {
    return this.array_element(definitions.catch_phrase_descriptor);
  },

  catch_phrase_noun() {
    return this.array_element(definitions.catch_phrase_noun);
  },

  bs_adjective() {
    return this.array_element(definitions.bs_adjective);
  },

  bs_buzz() {
    return this.array_element(definitions.bs_buzz);
  },

  bs_noun() {
    return this.array_element(definitions.bs_noun);
  },

  phone_formats() {
    return this.array_element(definitions.phone_formats);
  },

  domain_suffix() {
    return this.array_element(definitions.domain_suffix);
  },

};

module.exports = random;
