const checkService = require('./checkService');
const banklist = require('./definitions').cn_bank;

const bankList = () => banklist;

const randomBank = () => banklist[Math.floor(Math.random() * banklist.length)];

// 随机生成一个卡号
const RandomCreateBankID = (_bankType) => {
  const bankTypeName = _bankType ? banklist
    .filter(item => item.indexOf(_bankType) !== -1)[0] : randomBank();
  const [, bankType] = bankTypeName.split(' ');
  let bankNo = '';
  let flag = true;
  while (flag) {
    const cardPrefix = [];
    if (
      bankType === 'ICBC'
      || bankType === 'CCB'
      || bankType === 'ABC'
      || bankType === 'PSBC'
      || bankType === 'BCOM'
      || bankType === 'GDB'
      || bankType === 'BOC'
    ) {
      for (let j = 0; j < 13; j += 1) {
        cardPrefix.push(parseInt(Math.random() * 10, 10));
      }
    } else {
      for (let j = 0; j < 10; j += 1) {
        cardPrefix.push(parseInt(Math.random() * 10, 10));
      }
    }
    const cardPrefixs = cardPrefix.join('');
    switch (bankType) {
      case 'CCB':
        bankNo = `621700${cardPrefixs}`;
        break;
      case 'CMBC':
        bankNo = `621691${cardPrefixs}`;
        break;
      case 'ABC':
        bankNo = `622827${cardPrefixs}`;
        break;
      case 'BCOM':
        bankNo = `622262${cardPrefixs}`;
        break;
      case 'CMB':
        bankNo = `621486${cardPrefixs}`;
        break;
      case 'SPDB':
        bankNo = `622521${cardPrefixs}`;
        break;
      case 'GDB':
        bankNo = `622568${cardPrefixs}`;
        break;
      case 'HXB':
        bankNo = `622632${cardPrefixs}`;
        break;
//      case 'PAB':
//        bankNo = `622298${cardPrefixs}`;
//        break;
      case 'CITIC':
        bankNo = `622696${cardPrefixs}`;
        break;
      case 'ICBC':
        bankNo = `620058${cardPrefixs}`;
        break;
      case 'BOC':
        bankNo = `620061${cardPrefixs}`;
        break;
      case 'CIB':
        bankNo = `622908${cardPrefixs}`;
        break;
      case 'CEB':
        bankNo = `622660${cardPrefixs}`;
        break;
      case 'PSBC':
        bankNo = `621799${cardPrefixs}`;
        break;
      default:
        bankNo = `621700${cardPrefixs}`;
    }
    if (checkService.luhnCheck(bankNo)) {
      flag = false;
    }
  }
  return { bankType: bankTypeName, bankNo };
};

module.exports = {
  RandomCreateBankID,
  bankList,
  randomBank,
};
