const fs = require('fs');
const Router = require('koa-router');

const router = new Router();
const log4js = require('koa-log4');

const logger = log4js.getLogger('router');

// 解析规则 {'GET /': homepage}
function addRule(_router, rule) {
  Object.keys(rule).forEach((key) => {
    // key = 'GET /' rule = {'GET /': homepage}
    if (key.startsWith('GET ')) {
      const path = key.substring(4);
      _router.get(path, rule[key]);
      logger.info(`register URL mapping: GET ${path}`);
    } else if (key.startsWith('POST ')) {
      const path = key.substring(5);
      _router.post(path, rule[key]);
      logger.info(`register URL mapping: POST ${path}`);
    } else {
      logger.info(`invalid URL: ${key}`);
    }
  });
}

// 自动导入controller文件夹下所有的路由规则
function addRules(_router) {
  // 得到 /controller 所有以js结尾的文件
  const files = fs.readdirSync(`${__dirname}/controller`);
  const jsFiles = files.filter(f => f.endsWith('.js'));

  // 添加规则
  jsFiles.forEach((jsFile) => {
    // console.log(`process controller: ${f}...`);
    logger.info(`process controller: ${jsFile}...`);
    const rule = require(`${__dirname}/controller/${jsFile}`);
    addRule(_router, rule);
  });
}

module.exports = () => {
  addRules(router);
  return router.routes();
};
