/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.util;

import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Resolver {
    private static final ILogger logger = LoggerFactory.getLogger("Resolver");
    public static final Pattern BOOL = Pattern.compile("^(?:yes|Yes|YES|no|No|NO|true|True|TRUE|false|False|FALSE|on|On|ON|off|Off|OFF)$");
    public static final Pattern FLOAT = Pattern.compile("^([-+]?(\\.[0-9]+|[0-9_]+(\\.[0-9_]*)?)([eE][-+]?[0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
    public static final Pattern INT = Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?[0-9])+)$");
    public static final Pattern MERGE = Pattern.compile("^(?:<<)$");
    public static final Pattern NULL = Pattern.compile("^(?:~|null|Null|NULL| )$");
    public static final Pattern EMPTY = Pattern.compile("^$");
    public static final Pattern TIMESTAMP = Pattern.compile("^(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9][0-9][0-9][0-9]-[0-9][0-9]?-[0-9][0-9]?(?:[Tt]|[ \t]+)[0-9][0-9]?:[0-9][0-9]:[0-9][0-9](?:\\.[0-9]*)?(?:[ \t]*(?:Z|[-+][0-9][0-9]?(?::[0-9][0-9])?))?)$");
    protected Map<Class<?>, Pattern> implicitResolvers = new LinkedHashMap();

    public Resolver(boolean respectDefaultImplicitScalars) {
        if (respectDefaultImplicitScalars) {
            this.addImplicitResolvers();
        }
    }

    protected void addImplicitResolvers() {
        this.implicitResolvers.put(Boolean.class, BOOL);
        this.implicitResolvers.put(Integer.class, INT);
        this.implicitResolvers.put(Double.class, FLOAT);
        this.implicitResolvers.put(Date.class, TIMESTAMP);
        this.implicitResolvers.put(null, NULL);
    }

    public Object resolverValue(String value) {
        Class<?> valueClazz = null;
        for (Class<?> clazz : this.implicitResolvers.keySet()) {
            Pattern regexp = this.implicitResolvers.get(clazz);
            if (!regexp.matcher(value).matches()) continue;
            valueClazz = clazz;
            break;
        }
        if (valueClazz == null) {
            return value;
        }
        try {
            Method method = valueClazz.getMethod("valueOf", String.class);
            return method.invoke(null, value);
        }
        catch (SecurityException e) {
            logger.error("Properties resolverValue throw  SecurityException ", e);
        }
        catch (NoSuchMethodException e) {
            logger.error("Properties resolverValue throw  NoSuchMethodException ", e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Properties resolverValue throw  IllegalArgumentException ", e);
        }
        catch (IllegalAccessException e) {
            logger.error("Properties resolverValue throw  IllegalAccessException ", e);
        }
        catch (InvocationTargetException e) {
            logger.error("Properties resolverValue throw  InvocationTargetException ", e);
        }
        return value;
    }
}

