/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.jvmgc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DefaultDetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryPoolType;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.UnknownDetailedMemoryMetric;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedMemoryMetricProvider
implements Provider<DetailedMemoryMetric> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public DetailedMemoryMetricProvider() {
    }

    public DetailedMemoryMetric get() {
        DetailedMemoryMetric detailedMemoryMetric = null;
        Map<String, MemoryPoolMXBean> memoryPoolMap = this.createMemoryPoolMap();
        for (MemoryPoolType memoryPoolType : MemoryPoolType.values()) {
            if (!memoryPoolMap.containsKey(memoryPoolType.oldSpace())) continue;
            detailedMemoryMetric = this.createMetric(memoryPoolMap, memoryPoolType);
            break;
        }
        if (detailedMemoryMetric == null) {
            detailedMemoryMetric = new UnknownDetailedMemoryMetric();
        }
        this.logger.info("loaded : {}", (Object)detailedMemoryMetric);
        return detailedMemoryMetric;
    }

    private Map<String, MemoryPoolMXBean> createMemoryPoolMap() {
        HashMap<String, MemoryPoolMXBean> memoryPoolMap = new HashMap<String, MemoryPoolMXBean>();
        List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            memoryPoolMap.put(memoryPool.getName(), memoryPool);
        }
        return memoryPoolMap;
    }

    private DetailedMemoryMetric createMetric(Map<String, MemoryPoolMXBean> memoryPools, MemoryPoolType poolType) {
        MemoryPoolMXBean edenSpacePool = memoryPools.get(poolType.edenSpace());
        MemoryPoolMXBean oldSpacePool = memoryPools.get(poolType.oldSpace());
        MemoryPoolMXBean survivorSpacePool = memoryPools.get(poolType.survivorSpace());
        MemoryPoolMXBean codeCachePool = memoryPools.get(poolType.codeCache());
        MemoryPoolMXBean permGenPool = memoryPools.get(poolType.permGen());
        MemoryPoolMXBean metaspacePool = memoryPools.get(poolType.metaspace());
        return new DefaultDetailedMemoryMetric(poolType, edenSpacePool, oldSpacePool, survivorSpacePool, codeCachePool, permGenPool, metaspacePool);
    }
}

