/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.ByteMessage;
import com.navercorp.pinpoint.profiler.sender.MessageSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftUdpMessageSerializer
implements MessageSerializer<ByteMessage> {
    public static final int UDP_MAX_PACKET_LENGTH = 65507;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HeaderTBaseSerializer serializer;
    private final int maxPacketLength;
    private final MessageConverter<TBase<?, ?>> messageConverter;

    public ThriftUdpMessageSerializer(MessageConverter<TBase<?, ?>> messageConverter, int maxPacketLength) {
        this.messageConverter = (MessageConverter)Assert.requireNonNull(messageConverter, (String)"messageConverter must not be null");
        this.maxPacketLength = maxPacketLength;
        HeaderTBaseSerializerFactory headerTBaseSerializerFactory = new HeaderTBaseSerializerFactory(false, maxPacketLength, false);
        this.serializer = (HeaderTBaseSerializer)headerTBaseSerializerFactory.createSerializer();
    }

    @Override
    public ByteMessage serializer(Object message) {
        if (message instanceof TBase) {
            TBase tBase = (TBase)message;
            return this.serialize(tBase);
        }
        TBase<?, ?> tBase = this.messageConverter.toMessage(message);
        if (tBase != null) {
            return this.serialize(tBase);
        }
        return null;
    }

    public ByteMessage serialize(TBase<?, ?> message) {
        TBase<?, ?> dto = message;
        byte[] internalBufferData = this.serialize(this.serializer, dto);
        if (internalBufferData == null) {
            this.logger.warn("interBufferData is null");
            return null;
        }
        int messageSize = this.serializer.getInterBufferSize();
        if (this.isLimit(messageSize)) {
            this.logger.warn("discard packet. Caused:too large message. size:{}, {}", (Object)messageSize, dto);
            return null;
        }
        return new ByteMessage(internalBufferData, messageSize);
    }

    private byte[] serialize(HeaderTBaseSerializer serializer, TBase tBase) {
        try {
            return serializer.serialize(tBase);
        }
        catch (TException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Serialize " + tBase + " failed. Error:" + e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @VisibleForTesting
    protected boolean isLimit(int interBufferSize) {
        return interBufferSize > this.maxPacketLength;
    }
}

