/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitorRegistry;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryAdaptor;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.interceptor.factory.AnnotatedInterceptorFactory;
import com.navercorp.pinpoint.profiler.interceptor.factory.ExceptionHandlerFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.AutoBindingObjectFactory;
import com.navercorp.pinpoint.profiler.objectfactory.InterceptorArgumentProvider;

public class ObjectBinderFactory {
    private final ProfilerConfig profilerConfig;
    private final Provider<TraceContext> traceContextProvider;
    private final DataSourceMonitorRegistry dataSourceMonitorRegistry;
    private final Provider<ApiMetaDataService> apiMetaDataServiceProvider;
    private final ExceptionHandlerFactory exceptionHandlerFactory;

    public ObjectBinderFactory(ProfilerConfig profilerConfig, Provider<TraceContext> traceContextProvider, DataSourceMonitorRegistryService dataSourceMonitorRegistryService, Provider<ApiMetaDataService> apiMetaDataServiceProvider, ExceptionHandlerFactory exceptionHandlerFactory) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.traceContextProvider = (Provider)Assert.requireNonNull(traceContextProvider, (String)"traceContextProvider must not be null");
        Assert.requireNonNull((Object)dataSourceMonitorRegistryService, (String)"dataSourceMonitorRegistryService must not be null");
        this.dataSourceMonitorRegistry = new DataSourceMonitorRegistryAdaptor(dataSourceMonitorRegistryService);
        this.apiMetaDataServiceProvider = (Provider)Assert.requireNonNull(apiMetaDataServiceProvider, (String)"apiMetaDataServiceProvider must not be null");
        this.exceptionHandlerFactory = (ExceptionHandlerFactory)Assert.requireNonNull((Object)exceptionHandlerFactory, (String)"exceptionHandlerFactory must not be null");
    }

    public AutoBindingObjectFactory newAutoBindingObjectFactory(InstrumentContext pluginContext, ClassLoader classLoader, ArgumentProvider ... argumentProviders) {
        TraceContext traceContext = (TraceContext)this.traceContextProvider.get();
        return new AutoBindingObjectFactory(this.profilerConfig, traceContext, pluginContext, classLoader, argumentProviders);
    }

    public InterceptorArgumentProvider newInterceptorArgumentProvider(InstrumentClass instrumentClass) {
        ApiMetaDataService apiMetaDataService = (ApiMetaDataService)this.apiMetaDataServiceProvider.get();
        return new InterceptorArgumentProvider(this.dataSourceMonitorRegistry, apiMetaDataService, instrumentClass);
    }

    public AnnotatedInterceptorFactory newAnnotatedInterceptorFactory(InstrumentContext pluginContext) {
        TraceContext traceContext = (TraceContext)this.traceContextProvider.get();
        ApiMetaDataService apiMetaDataService = (ApiMetaDataService)this.apiMetaDataServiceProvider.get();
        return new AnnotatedInterceptorFactory(this.profilerConfig, traceContext, this.dataSourceMonitorRegistry, apiMetaDataService, pluginContext, this.exceptionHandlerFactory);
    }
}

