/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.memory;

import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryPoolType;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

public class DefaultDetailedMemoryMetric
implements DetailedMemoryMetric {
    private final MemoryPoolType memoryPoolType;
    private final MemoryPoolMXBeanWrapper codeCachePool;
    private final MemoryPoolMXBeanWrapper edenSpacePool;
    private final MemoryPoolMXBeanWrapper oldSpacePool;
    private final MemoryPoolMXBeanWrapper survivorSpacePool;
    private final MemoryPoolMXBeanWrapper permGenPool;
    private final MemoryPoolMXBeanWrapper metaspacePool;

    public DefaultDetailedMemoryMetric(MemoryPoolType memoryPoolType, MemoryPoolMXBean edenSpacePool, MemoryPoolMXBean oldSpacePool, MemoryPoolMXBean survivorSpacePool, MemoryPoolMXBean codeCachePool, MemoryPoolMXBean permGenPool, MemoryPoolMXBean metaspacePool) {
        if (memoryPoolType == null) {
            throw new NullPointerException("memoryPoolType must not be null");
        }
        this.memoryPoolType = memoryPoolType;
        this.codeCachePool = DefaultDetailedMemoryMetric.wrap(codeCachePool);
        this.edenSpacePool = DefaultDetailedMemoryMetric.wrap(edenSpacePool);
        this.oldSpacePool = DefaultDetailedMemoryMetric.wrap(oldSpacePool);
        this.survivorSpacePool = DefaultDetailedMemoryMetric.wrap(survivorSpacePool);
        this.permGenPool = DefaultDetailedMemoryMetric.wrap(permGenPool);
        this.metaspacePool = DefaultDetailedMemoryMetric.wrap(metaspacePool);
    }

    @Override
    public DetailedMemoryMetricSnapshot getSnapshot() {
        double edenSpaceMemoryUsage = this.calculateUsage(this.edenSpacePool.getUsage());
        double oldSpaceMemoryUsage = this.calculateUsage(this.oldSpacePool.getUsage());
        double survivorSpaceMemoryUsage = this.calculateUsage(this.survivorSpacePool.getUsage());
        double codeCacheMemoryUsage = this.calculateUsage(this.codeCachePool.getUsage());
        double permGenMemoryUsage = this.calculateUsage(this.permGenPool.getUsage());
        double metaspaceMemoryUsage = this.calculateUsage(this.metaspacePool.getUsage());
        return new DetailedMemoryMetricSnapshot(edenSpaceMemoryUsage, oldSpaceMemoryUsage, survivorSpaceMemoryUsage, codeCacheMemoryUsage, permGenMemoryUsage, metaspaceMemoryUsage);
    }

    public String toString() {
        return (Object)((Object)this.memoryPoolType) + " detailed memory metric";
    }

    private double calculateUsage(MemoryUsage memoryUsage) {
        long max;
        if (memoryUsage == null) {
            return -1.0;
        }
        long l = max = memoryUsage.getMax() == -1L ? memoryUsage.getCommitted() : memoryUsage.getMax();
        if (max == -1L || max == 0L) {
            return -1.0;
        }
        return (double)memoryUsage.getUsed() / (double)max;
    }

    private static MemoryPoolMXBeanWrapper wrap(final MemoryPoolMXBean memoryPoolMXBean) {
        if (memoryPoolMXBean == null) {
            return new MemoryPoolMXBeanWrapper(){

                @Override
                public MemoryUsage getUsage() {
                    return null;
                }
            };
        }
        return new MemoryPoolMXBeanWrapper(){

            @Override
            public MemoryUsage getUsage() {
                return memoryPoolMXBean.getUsage();
            }
        };
    }

    private static interface MemoryPoolMXBeanWrapper {
        public MemoryUsage getUsage();
    }
}

