/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.buffer;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.thrift.dto.TDirectBuffer;

public class DefaultBufferMetricCollector
implements AgentStatMetricCollector<TDirectBuffer> {
    private final BufferMetric bufferMetric;

    public DefaultBufferMetricCollector(BufferMetric bufferMetric) {
        if (bufferMetric == null) {
            throw new NullPointerException("bufferMetric must not be null");
        }
        this.bufferMetric = bufferMetric;
    }

    @Override
    public TDirectBuffer collect() {
        BufferMetricSnapshot snapshot = this.bufferMetric.getSnapshot();
        TDirectBuffer tdirectBuffer = new TDirectBuffer();
        tdirectBuffer.setDirectCount(snapshot.getDirectCount());
        tdirectBuffer.setDirectMemoryUsed(snapshot.getDirectMemoryUsed());
        tdirectBuffer.setMappedCount(snapshot.getMappedCount());
        tdirectBuffer.setMappedMemoryUsed(snapshot.getMappedMemoryUsed());
        return tdirectBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultBufferMetricCollector{");
        sb.append("bufferMetric=").append(this.bufferMetric);
        sb.append('}');
        return sb.toString();
    }
}

